<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Chart Data from Database</h1>
<div id="chartContainer"></div>

<?php
    error_reporting(E_ERROR | E_PARSE);
    $conn = mysqli_connect('localhost:3306', 'root', '');
    if (!$conn) {
        die('<div class="alert alert-danger" style="margin:1%;">Could not connect to the database. Set Database Username and Password in the file "/data-binding/chart-data-from-database.php"</div>');
    }
    $selected_database = mysqli_select_db($conn, "canvasjs_db");
    if (!$selected_database) {
        die('<div class="alert alert-danger" style="margin:1%;">Required database does not exist. Please import the canvasjs_db.sql file in the downloaded zip package '
                . '(<a href="https://www.digitalocean.com/community/tutorials/how-to-import-and-export-databases-and-reset-a-root-password-in-mysql" target="_blank">Instructions to Import.</a>).</div>');
    }
    $query = "select * from datapoints";
    $data = mysqli_query($conn, $query);
    $dataPoints = array();
    while ($row = mysqli_fetch_array($data, MYSQLI_ASSOC)) {
        array_push($dataPoints, $row);
    }
?>
 
<script>
    window.onload = function () {
        var chart = new CanvasJS.Chart("chartContainer", {
            animationEnabled: true,
            exportEnabled: true,
            theme: "light1", // "light1", "light2", "dark1", "dark2"
            title:{
                text: "PHP Column Chart from Database"
            },
            data: [{
                type: "column", //change type to bar, line, area, pie, etc  
                dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
            }]
        });
        chart.render();
    }
</script>

<?php include '../footer.php'; ?>